/************************************************************************
 *
 * \file: DeviceMonitor.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: bdcl - Prototype
 *
 * \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
 * \author: P. Govindaraju / ADIT/SW1 / external.pgovindaraju@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef BDCLT_DEVICEMONITOR_H
#define BDCLT_DEVICEMONITOR_H

#include <atomic>
#include <list>
#include <pthread_adit.h>
#include <mutex>              // std::mutex, std::unique_lock
#include <condition_variable> // std::condition_variable, std::cv_status


// FeatureDiscovery headers
#include <uspi/FeatureDiscoveryTypes.h>
#include <uspi/FeatureDiscovery.h>
#include <uspi/IFeatureDiscovery.h>

// DeviceDetector headers
// included to set the device mask to watch for (enum DD_EVENT_MASK)
#include <uspi/deviceDetector.h>
// necessary to retrieve device attributes like vendorId, productId, serial
#include <uspi/deviceManagement.h>

#include "IStoppable.h"

namespace adit { namespace bdcl {

// handles switching, transport and session creation
class DeviceMonitor : public IStoppable, public adit::uspi::IFeatureDiscoveryCb
{
public:
    DeviceMonitor();
    virtual ~DeviceMonitor();


    void waitForExit();

    // IStoppable implementation
    void requestStop();
    
    // location to test the sensor source test
    void setLocation(std::string inLocation) { testLocation = inLocation; }
    std::string getLocation() { return testLocation; }

    bool getRunningStatus(){return running;}
    void resetDevice(void);

protected:
    bool startDeviceMonitor(uint32_t inEventMask);
    void stopDeviceMonitor();
    // some helpers
    void resetDevice(/*const*/ std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void waitForDeviceReset(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);

    virtual void onDeviceFound(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice) = 0;
    virtual void onDeviceLost(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice) = 0;
    virtual void onDeviceSwitched(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice) = 0;
    virtual void onDeviceChanged(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice) = 0;

private:
    /* callbacks received from FeatureDiscovery */
    adit::uspi::DiscoveryError foundCb(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    adit::uspi::DiscoveryError lostCb(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    adit::uspi::DiscoveryError switchedCb(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    adit::uspi::DiscoveryError changedCb(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    adit::uspi::DiscoveryError errorCb(adit::uspi::DiscoveryError inErrorCode);

    /* FeatureDiscovery */
    adit::uspi::FeatureDiscovery* discoverer;
    std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> resetInfo;
    std::atomic_flag resetFlag;
    pthread_mutex_t resetMutex;
    std::list<std::shared_ptr<adit::uspi::DiscoveredDeviceUsb>> resetInfos;
    std::string testLocation;

    std::condition_variable cvBdclDemo;
    std::mutex mutBdclDemo;
    bool running;
};

std::string to_string(adit::uspi::DeviceInfo& inVal);


} } /* namespace adit { namespace bdcl */
#endif /* BDCLT_DEVICEMONITOR_H */
